#!/bin/sh

exec_shell="bash" # set the shell you like.

base_dir="/mnt/us/documents"
log_pattern="KPPMainAppV2*"

# Find KPP crash logs
kpp_txt=$(find "$base_dir" -name "$log_pattern.txt")
kpp_tgz=$(find "$base_dir" -name "$log_pattern.tgz")
kpp_sdr=$(find "$base_dir" -type d -name "$log_pattern.sdr")

# Initialize variables to track which types of files were deleted
txt_deleted=0
tgz_deleted=0
sdr_deleted=0

# Delete files and update corresponding variables
if [ -n "$kpp_txt" ]; then
  find "$base_dir" -name "$log_pattern.txt" -exec rm {} +
  txt_deleted=1
fi

if [ -n "$kpp_tgz" ]; then
  find "$base_dir" -name "$log_pattern.tgz" -exec rm {} +
  tgz_deleted=1
fi

if [ -n "$kpp_sdr" ]; then
  find "$base_dir" -type d -name "$log_pattern.sdr" -exec rm -rf {} +
  sdr_deleted=1
fi

if [ $txt_deleted -eq 1 ] || [ $tgz_deleted -eq 1 ] || [ $sdr_deleted -eq 1 ]; then

  # Check if all types of logs were not deleted
  if [ $txt_deleted -eq 0 ] || [ $tgz_deleted -eq 0 ] || [ $sdr_deleted -eq 0 ]; then
    fbink -pmh -y -5 -F TERMINUS "Not all logs" "have been deleted."
    sleep 3
    fbink -pmh -y -5 -F TERMINUS "Wait ≈5 min" "and try again"
  else
    fbink -pmh -y -5 -F TERMINUS "KPP Crash Logs" "removed succesfully!"
  fi

else
  fbink -pmh -y -5 -F TERMINUS "There is nothing" "to remove"
fi
